# Adaptive Energy Alignment (AEA)

This repository is the official implementation of AEA (submitted paper).

## Overview

Our implementation is based on the TTAB benchmark (https://github.com/LINs-lab/ttab.git). \
We provide a command line code to run our AEA. \
Please refer to the TTAB official repository to install package requirements.

## Script for quick run
We provide an example script that can be used to reproduce our AEA on CIFAR10-C-gaussian_noise-5 dataset.


```bash
python run_exp.py \
--job_name aea_tta \
--data_path $PATH_FOR_CIFAR10C$ \
--ckpt_path ./pretrain/ckpt/resnet26_bn_ssh_cifar10.pth \
--model_adaptation_method enetta \
--data_names cifar10_c_deterministic-gaussian_noise-5 \
--loss_name em_energy_sp_wlcs
```


<!-- ## Citing TTAB -->

## Bibliography

```
@inproceedings{zhao2023ttab,
  title     = {On Pitfalls of Test-time Adaptation},
  author    = {Zhao, Hao and Liu, Yuejiang and Alahi, Alexandre and Lin, Tao},
  booktitle = {International Conference on Machine Learning (ICML)},
  year      = {2023},
}
```
